/* This part of the  do file creates an `informal institutions index' defined as the variation in the joint 
	governance index not explained by the formalinstitutions index. */
capture drop informalinst_index
capture drop linformalinst*
reg gov formalinstitutionsindex
predict informalinst_index, res 
label variable informalinst_index "Informal institutions"
replace informalinst_index = . if gov ==. | formalinstitutionsindex ==.
summarize informalinst_index
*replace informalinst_index = (informalinst_index - r(min))/(r(max)-r(min)) /* Normalize to range from 0 to 1 */
replace informalinst_index = informalinst_index/r(sd) /* Normalize to have sd = 1 */
summarize informalinst_index
hist informalinst_index

/* Figure: Formal instituinos vs. the governance index */

********************************************************************
****Generate a conflict category variables****
********************************************************************

capture drop conflict_72_90
capture drop conflict_91_05
by gwno, sort: egen conflict_72_90 = max(conflict) if year>=1972 & year<=1990
by gwno, sort: egen conflict_91_05 = max(conflict) if year>=1991 & year<=2005
sort gwno year
replace conflict_72_90 = conflict_72_90[_n-1] if conflict_72_90==. & gwno == gwno[_n-1]
replace conflict_91_05 = conflict_91_05[_n+1] if conflict_91_05==. & gwno == gwno[_n+1]
replace conflict_72_90 = 1 if conflict_72_90 == 2
replace conflict_91_05 = 1 if conflict_91_05 == 2
capture drop conflict_cat
gen conflict_cat = 0
replace conflict_cat = 0 if conflict_72_90 == 0	& conflict_91_05 == 0
replace conflict_cat = 1 if conflict_72_90 == 0 & conflict_91_05 == 1 
replace conflict_cat = 2 if conflict_72_90 == 1 & conflict_91_05 == 1
capture label drop conflict_cat
label define conflict_cat 0 "non-conflict" 1 "new conflict" 2 "conflict recurrence"

capture label define conflict_cat 0 "non-conflict" 1 "post-conflict" 2 "conflict"	


capture drop pos
gen pos = 3
replace pos = 1 if country == "Qatar"
replace pos = 9 if country == "Bulgaria"
replace pos = 2 if country == "Algeria"
replace pos = 5 if country == "Indonesia"
replace pos = 12 if country == "Luxembourg"
replace pos = 6 if country == "Ireland"
replace pos = 6 if country == "Papua New Guinea"
replace pos = 2 if country == "Mongolia"
replace pos = 12 if country == "Czech Republic"
replace pos = 6 if country == "South Africa"
replace pos = 4 if country == "Ghana"
replace pos = 5 if country == "Israel"
replace pos = 5 if country == "Iceland"
replace pos = 2 if country == "Finland"
replace pos = 1 if country == "Gambia"
replace pos = 4 if country == "United Kingdom"
replace pos = 2 if country == "Sweden"
replace pos = 2 if country == "Canada"
replace pos = 5 if country == "Mauritania"
replace pos = 4 if country == "Lao PDR"
replace pos = 2 if country == "Madagascar"

twoway ///
	(scatter gov formalinstitutionsindex if year == 1990 & conflict_cat==0, ///
		 xlabel(-1.5 -1 0 1 2) mlabel(country) msize(small) mlabsize(tiny) mlabv(pos)) || ///
	(scatter gov formalinstitutionsindex if year == 1990 & conflict_cat==1, xscale(range(-1.5 2)) mlabel(country) msize(small) mlabsize(tiny) mlabv(pos)) || ///
	(scatter gov formalinstitutionsindex if year == 1990 & conflict_cat==2, xscale(range(-1.5 2)) mlabel(country) msize(small) mlabsize(tiny) mlabv(pos)) || ///
	|| lfit gov formalinstitutionsindex if year == 1990, xscale(range(-1.5 2)) ytitle("Governance index") ///
	legend(label(1 No conflict) label(2 New conflict) label(3 Conflict recurrence) region(lstyle(none)) bm(tiny) size(small)) 

/* Formal inst. vs. informal inst. index */

capture drop pos
gen pos = 3
replace pos = 12 if country == "Czech Republic"
replace pos = 2 if country == "Finland"
replace pos = 5 if country == "Iceland"
replace pos = 4 if country == "United Kingdom"
replace pos = 2 if country == "Sweden"
replace pos = 2 if country == "Canada"
replace pos = 1 if country == "Qatar"
replace pos = 9 if country == "Bulgaria"
replace pos = 4 if country == "Madagascar"
replace pos = 2 if country == "Jordan"
replace pos = 1 if country == "Trinidad and Tobago"
replace pos = 5 if country == "Indonesia"
replace pos = 9 if country == "Australia"
replace pos = 9 if country == "Ireland"
replace pos = 4 if country == "Haiti"
replace pos = 4 if country == "Bolivia"
replace pos = 6 if country == "Russian Federation"
replace pos = 2 if country == "Iraq"
replace pos = 4 if country == "Egypt, Arab Rep."
replace pos = 2 if country == "Costa Rica"
replace pos = 2 if country == "Brazil"
replace pos = 9 if country == "South Africa"

twoway ///
	(scatter informalinst_index formalinstitutionsindex if year == 1990 & conflict_cat==0, ///
		 xlabel(-1.5 -1 0 1 2) mlabel(country) mlabsize(tiny) mlabv(pos) ) || ///
	(scatter informalinst_index formalinstitutionsindex if year == 1990 & conflict_cat==1, ///
		mlabel(country) mlabsize(tiny) mlabv(pos)) || ///
	(scatter informalinst_index formalinstitutionsindex if year == 1990 & conflict_cat==2, ///
		mlabel(country) mlabsize(tiny) mlabv(pos)), /// 
		legend(label(1 No Conflict) label(2 New Conflict) label(3 Conflict Recurrence) rows(1) region(lstyle(none) ) ///
		bm(tiny) size(small)) ytitle("Informal institutions index")



sort gwno year
gen linformalinstindex = informalinst_index[_n-1] if gwno==gwno[_n-1]
*gen lsqformalinstindex = formalinst_index2[_n-1]^2 if gwno==gwno[_n-1]
gen linformalinstltsc0 = linformalinstindex * ltsc0
*gen lsqformalinstltsc0 = lsqformalinstindex * ltsc0
eststo clear
*eststo: xi: logit conflict i.lconflict ltsc0 lformalinstindex lformalinstindexltsc0 llimr  lnc etdo4590 lpop lpopgrowth if linformalinstindex !=.
eststo: xi: logit conflict i.lconflict ltsc0 lformalinstindex lformalinstindexltsc0 lgdpcap  lnc etdo4590 lpop pkotraditional pkotransformational i.g_region if linformalinstindex !=.
eststo: xi: logit conflict i.lconflict ltsc0 linformalinstindex linformalinstltsc0 lgdpcap  lnc etdo4590 lpop pkotraditional pkotransformational i.g_region if lformalinstindex !=.
eststo: xi: logit conflict i.lconflict ltsc0 lformalinstindex lformalinstindexltsc0 linformalinstindex linformalinstltsc0 lgdpcap  lnc etdo4590 lpop pkotraditional pkotransformational i.g_region 


************************************
************Clarify*****************
************************************
set more off
capture drop _b*
capture drop clfy_*
capture drop ltsc0_sample
capture drop medianpi
capture drop p10pi 
capture drop p90pi
capture drop formal_axis 
capture drop informal_axis
capture drop pi

generate ltsc0_sample = .
generate formal_axis = .
generate informal_axis = .
local granularity = 0.20
local i = 1
foreach l in 0 2.303 {
	forvalues f = -2(`granularity')2 {
		forvalues if = -2(`granularity')2 {
			qui replace formal_axis = `f' in `i'
			qui replace informal_axis = `if' in `i'
			local i = `i' +1
		} /* end forvalues if = 0(0.05)1 */
	} /* end forvalues f = 0(0.05)1 */
} /* end foreach l in 0 2.70 */

generate medianpi = .
generate p10pi = .
generate p90pi = .

xi: estsimp logit conflict i.lconflict ltsc0 lformalinstindex lformalinstindexltsc0 ///
	linformalinstindex linformalinstltsc0 lgdpcap lnc etdo4590 lpop, genname(_b)

local i = 1	
foreach l in 0 2.303 {
	forvalues f = -2(`granularity')2 {
		forvalues if = -2(`granularity')2 {
			display `f' ", " `if'
			setx lformalinstindex `f'
			setx linformalinstindex `if'
			setx ltsc0 `l' lformalinstindexltsc0 `l'*`f' linformalinstltsc0 `l'*`if'
			setx  lgdpcap 8.02 lpop 8.87 etdo4590 .5 lnc 0 _Ilconflict_1 0 _Ilconflict_2 0
			quietly simqi, prval(1) genpr(pi)
			_pctile pi, p(10,50,90)
			qui replace medianpi = r(r2) in `i'
			qui replace p10pi = r(r1) in `i'
			qui replace p90pi = r(r3) in `i'
			qui replace ltsc0_sample = `l' in `i'
			drop pi
			local i = `i' + 1
			} /* end forvalues if = 0(0.05)1 */
	} /* end forvalues f = 0(0.05)1 */
} /* end foreach l in 0 2.70 */

list formal_axis informal_axis medianpi ltsc0_sample if ltsc0_sample == 0
list formal_axis informal_axis medianpi p10pi p90pi ltsc0_sample if ///
	((formal_axis > -1.21 & formal_axis < -1.19 ) | (formal_axis >= 1.19 & formal_axis <= 1.21)) ///
	& ((informal_axis >= -1.21 & informal_axis < -1.19) | (informal_axis > 1.19 & informal_axis < 1.21) )


twoway contour medianpi informal_axis formal_axis if medianpi !=. & ltsc0_sample == 0, ccuts(0(0.02)0.14) ///
	xtitle("Formal institutions index") ytitle("Informal institutions index") ztitle("Median predicted probability")
	
twoway contour medianpi informal_axis formal_axis if medianpi !=. & ltsc0_sample != 0, ccuts(0(0.02)0.14) ///
	xtitle("Formal institutions index") ytitle("Informal institutions index") ztitle("Median predicted probability")



/* This part of the  do file creates an `surplus governance index' defined as the variation in the joint 
	governance index not explained by log GPD per capita. */


capture drop surplusgov_index
capture drop lsurplusgov*
reg gov lgdpcap
predict surplusgov_index, res 
label variable surplusgov_index "Surplus governance"
replace surplusgov_index = . if gov ==. | lgdpcap ==.
summarize surplusgov_index
replace surplusgov_index = surplusgov_index/r(sd) /* Normalize to have sd = 1 */
summarize surplusgov_index
hist surplusgov_index
sort gwno year
gen lsurplusgov_index = surplusgov_index[_n-1] if gwno==gwno[_n-1]


*gen lsqformalinstindex = formalinst_index2[_n-1]^2 if gwno==gwno[_n-1]
gen lsurplusgovltsc0 = lsurplusgov_index * ltsc0


/* Figure */

capture drop pos
gen pos = 3
replace pos = 6 if country == "Luxembourg"
replace pos = 2 if country == "Malawi"
replace pos = 4 if country == "Mongolia"
replace pos = 1 if country == "New Zealand"
replace pos = 5 if country == "United Kingdom"
replace pos = 4 if country == "Congo, Dem. Rep."
replace pos = 5 if country == "Korea, Rep."
replace pos = 1 if country == "Greece"
replace pos = 6 if country == "Niger"
replace pos = 1 if country == "Chad"
replace pos = 2 if country == "Libya"
replace pos = 9 if country == "Austria"
replace pos = 2 if country == "Sierra Leone"
replace pos = 9 if country == "Australia"
replace pos = 4 if country == "Mauritania"
replace pos = 6 if country == "Mexico"
replace pos = 5 if country == "Zimbabwe"
replace pos = 1 if country == "Argentina"
replace pos = 2 if country == "Poland"
replace pos = 4 if country == "Panama"
replace pos = 12 if country == "Ghana"
replace pos = 6 if country == "India"
replace pos = 9 if country == "Mali"
replace pos = 9 if country == "Togo"
replace pos = 9 if country == "Guinea-Bissau"


*local gdplab = `" 5.521 "250" 6.215 "500" 6.908 "1000" 7.924 "2500" 8.517 "5000" 9.21 "10000" 10.127 "25000" 10.82 "50000" "'
local gdplab = `" 6.215 "500" 6.908 "1000" 7.924 "2500" 8.517 "5000" 9.21 "10000" 10.127 "25000" "'
local gdptitle = "Log GDP per capita, constant 2000 USD"
twoway ///
	(scatter surplusgov_index lgdpcap if year == 1990 & conflict_cat==0, mlabel(country) mlabsize(tiny) mlabv(pos)) || ///
	(scatter surplusgov_index lgdpcap if year == 1990 & conflict_cat==1, mlabel(country) mlabsize(tiny) mlabv(pos)) || ///
	(scatter surplusgov_index lgdpcap if year == 1990 & conflict_cat==2, mlabel(country) mlabsize(tiny) mlabv(pos)), ///
	legend(label(1 No conflict) label(2 New conflict) label(3 Conflict recurrence) region(lstyle(none)) ///
		bm(tiny) size(small) rows(1)) xlabel(`gdplab') xtitle(`"`gdptitle'"')



capture drop pos
gen pos = 3
replace pos = 12 if country == "Luxembourg"
replace pos = 5 if country == "United Arab Emirates"
replace pos = 6 if country == "Ireland"
replace pos = 4 if country == "Bolivia"
replace pos = 5 if country == "Nicaragua"
replace pos = 6 if country == "Venezuela, RB"
replace pos = 2 if country == "Chile"
replace pos = 9 if country == "Netherlands"
replace pos = 6 if country == "Iraq"
replace pos = 6 if country == "Uganda"
replace pos = 1 if country == "Equatorial Guinea"
replace pos = 9 if country == "Belgium"
replace pos = 2 if country == "Mexico"
replace pos = 4 if country == "Oman"
replace pos = 4 if country == "Uruguay"
replace pos = 4 if country == "Argentina"
replace pos = 4 if country == "Morocco"
replace pos = 4 if country == "Dominican Republic"
replace pos = 6 if country == "Congo, Dem. Rep."
replace pos = 2 if country == "Zambia"
replace pos = 2 if country == "Bhutan"
replace pos = 4 if country == "Senegal"
replace pos = 5 if country == "Tunisia"
replace pos = 4 if country == "Libya"
replace pos = 5 if country == "Thailand"
replace pos = 4 if country == "Costa Rica"
replace pos = 4 if country == "Mauritius"
replace pos = 4 if country == "Swaziland"
replace pos = 2 if country == "Guinea"
replace pos = 4 if country == "Honduras"
replace pos = 5 if country == "Paraguay"
replace pos = 6 if country == "Panama"

local gdplab = `" 6.215 "500" 6.908 "1000" 7.924 "2500" 8.517 "5000" 9.21 "10000" 10.127 "25000" "'
local gdptitle = "Log GDP per capita, constant 2000 USD"
twoway ///
	(scatter informalinst_index lgdpcap if year == 1990 & conflict_cat==0, mlabel(country) mlabsize(tiny) mlabv(pos)) || ///
	(scatter informalinst_index lgdpcap if year == 1990 & conflict_cat==1, mlabel(country) mlabsize(tiny) mlabv(pos)) || ///
	(scatter informalinst_index lgdpcap if year == 1990 & conflict_cat==2, mlabel(country) mlabsize(tiny) mlabv(pos)), ///
	legend(label(1 No conflict) label(2 New conflict) label(3 Conflict recurrence) region(lstyle(none)) bm(tiny) size(small)) xlabel(`gdplab') xtitle(`"`gdptitle'"')



eststo clear
eststo: xi: logit conflict i.lconflict lgdpcap lgdpcapltsc0 ltsc0 lnc etdo4590 lpop pkotraditional pkotransformational i.g_region  if lsurplusgovltsc0 !=. & lgdpcap !=.
eststo: xi: logit conflict i.lconflict lsurplusgov_index lsurplusgovltsc0 lgdpcap lgdpcapltsc0 ltsc0 lnc etdo4590 lpop  pkotraditional pkotransformational i.g_region  if lsurplusgovltsc0 !=. & lgdpcap !=.
eststo: xi: logit conflict i.lconflict lsurplusgov_index lsurplusgovltsc0 lformalinstindex lformalinstindexltsc0  lgdpcap lgdpcapltsc0 ltsc0 lnc etdo4590 lpop pkotraditional pkotransformational i.g_region  if lsurplusgovltsc0 !=. & lgdpcap !=.


************************************
************Clarify*****************
************************************
set more off
capture drop _b*
capture drop clfy_*
capture drop ltsc0_sample
capture drop medianpi
capture drop p10pi 
capture drop p90pi
capture drop spgov_axis 
capture drop gdpcap_axis
capture drop pi

generate ltsc0_sample = .
generate spgov_axis = .
generate gdpcap_axis = .
local granularity = 0.20
local gdpcapstart = 5
local gdpcapend = 10
local gdpcapgran = 0.25

local i = 1
foreach l in 0 2.303 {
	forvalues sp = -2(`granularity')2 {
		forvalues g = `gdpcapstart'(`gdpcapgran')`gdpcapend' {
			qui replace spgov_axis = `sp' in `i'
			qui replace gdpcap_axis = `g' in `i'
			local i = `i' +1
		} /* end forvalues if = 0(0.05)1 */
	} /* end forvalues f = 0(0.05)1 */
} /* end foreach l in 0 2.70 */

generate medianpi = .
generate p10pi = .
generate p90pi = .

xi: estsimp logit conflict i.lconflict lsurplusgov_index lsurplusgovltsc0 lgdpcap ///
	lgdpcapltsc0 ltsc0 lnc etdo4590 lpop  if lsurplusgovltsc0 !=. & lgdpcap !=., genname(_b)

local i = 1	
foreach l in 0 2.303 {
	forvalues sp = -2(`granularity')2 {
		forvalues g = `gdpcapstart'(`gdpcapgran')`gdpcapend' {
			display `sp' ", " `g'
			setx lsurplusgov_index `sp'
			setx lgdpcap `g'
			setx ltsc0 `l' lsurplusgov_index `sp' lsurplusgovltsc0 `l'*`sp' lgdpcap `g' 
*			dis "here"
			setx lgdpcapltsc0 `g'*`l' 
			setx  lpop 9.08 etdo4590 .5 lnc 0 _Ilconflict_1 0 _Ilconflict_2 0
			quietly simqi, prval(1) genpr(pi)
			_pctile pi, p(10,50,90)
			qui replace medianpi = r(r2) in `i'
			qui replace p10pi = r(r1) in `i'
			qui replace p90pi = r(r3) in `i'
			qui replace ltsc0_sample = `l' in `i'
			drop pi
			local i = `i' + 1
			} /* end forvalues if = 0(0.05)1 */
	} /* end forvalues f = 0(0.05)1 */
} /* end foreach l in 0 2.70 */

/* Listing values for CI table */
list ltsc0_sample spgov_axis gdpcap_axis medianpi p10pi p90pi ///
	if ((spgov_axis >-1.21 & spgov_axis < -1.19) | (spgov_axis > 1.19 & spgov_axis < 1.21)) ///
	& ((gdpcap_axis > 6.2 & gdpcap_axis < 6.3) | (gdpcap_axis > 8.95 & gdpcap_axis < 9.05))

local gdplab = `" 5.521 "250" 6.215 "500" 6.908 "1000" 7.924 "2500" 8.517 "5000" 9.21 "10000" "'

twoway contour medianpi spgov_axis gdpcap_axis if medianpi !=. & ltsc0_sample == 0, ccuts(0(0.02)0.14) xlabel(`gdplab') ///
	xtitle("GDP per capita") ytitle("Surplus governance") ztitle("Median predicted probability")

twoway contour medianpi spgov_axis gdpcap_axis if medianpi !=. & ltsc0_sample != 0, ccuts(0(0.02)0.14) xlabel(`gdplab') ///
	xtitle("GDP per capita") ytitle("Surplus governance") ztitle("Median predicted probability")



